%%%%KM-SUB-Skin-Clothing function file code for making Figure 6a in Lakey at al. Comms. Chem. 2, 56 (2019)

function dydt=KMSUB_Skin_Clothing_F(t,y)
warning off all

global scL1 scL2 veL NCom sigma W a0_1 kd_1 Ho3 A V_sc1 V_sc2 V_ve Airexchangerate
global vekbb scvekbb kaO3 kclothes_gap ksc1_sc2
global ka K kbr kgr S Volume_of_room
global koil_s_o3 koil_s_vol oil_kbb oil_sc_kbb V_oil mfp_vol
global oilL clothesL kclothes_bb kclothes_bl_clothes Dg V_clothes Clothes_fraction_air
global sckbb1 sckbb2 hm gapR  kclothes_gap_mfp K_clothing Clothes_fraction_fibres

%---------Initialise matrix sizes-----------
dydt=zeros((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+2*NCom,1); dzdt=zeros(NCom,oilL+scL1+veL+(2*clothesL)+2+2+scL2);

%----------------------------------------------------------------------
%%%%%%----------convert y to z-----------%%%%%%

z=zeros(NCom,((oilL+scL1+(2*clothesL)+veL+2+2+scL2)*(NCom)));
for i=1:NCom
    for m=1:oilL+scL1+veL+(2*clothesL)+2+2+scL2
        z(i,m)=y((oilL+scL1+(2*clothesL)+veL+2+2+scL2)*(i-1)+m);
    end
end

%----------------------------------------------------------------------
Thetas_1=sigma(1).*z(1,1)+sigma(2).*z(2,1)+sigma(3).*z(3,1)+sigma(5).*z(17,1)...
    +sigma(6).*z(18,1)+sigma(7).*z(19,1)+sigma(11).*z(23,1)+sigma(12).*z(24,1)...
    +sigma(13).*z(25,1)+sigma(14).*z(26,1); %Sorption layer surface coverage

ks_oil_o3=(Ho3.*koil_s_o3.*kd_1)/(kaO3.*(1-Thetas_1)); %Transport rate from the sorption layer to the skin oil for ozone (s-1)

for i=[17:19,23:26]
ks_oil_vol(i)=(K(i).*koil_s_vol(i).*kd_1)/(ka(i).*(1-Thetas_1)); %Transport rate from the sorption layer to the skin oil for volatile species (s-1)
end

%%%%%%%----------transport fluxes----------------%%%%%%
JcollO3_1=W(1)./4.*z(1,oilL+scL1+veL+(2*clothesL)+2+2); %Collision flux of O3 to the skin surface (cm-2 s-1)
JadsO3_1=a0_1.*(1-Thetas_1).*JcollO3_1; %Adsorption flux of O3 to the skin surface (cm-2 s-1)
JdesO3_1=kd_1*z(1,1); %Desorption flux of O3 from the skin surface (cm-2 s-1)
Js_oil_O3=ks_oil_o3*z(1,1); %Flux of ozone from the sorption layer to the skin oil (cm-2 s-1)
Joil_sO3=koil_s_o3*z(1,2); %Flux of ozone from the skin oil to the sorption layer (cm-2 s-1)

%-----Transport fluxes for volatile species------
Jcoll_1=zeros(30,1);
Jads_1=zeros(30,1);
Jdes_1=zeros(30,1);
Js_oil_vol=zeros(30,1);
Joil_svol=zeros(30,1);

for i=[17:19,23:26]
Jcoll_1(i)=W(i-12)./4.*z(i,oilL+scL1+veL+(2*clothesL)+2+2); %Collision flux of volatile species to the skin surface (cm-2 s-1)
Jads_1(i)=a0_1.*(1-Thetas_1).*Jcoll_1(i); %Adsorption flux of volatile species to the skin surface (cm-2 s-1)
Jdes_1(i)=kd_1*z(i,1); %Desorption flux of volatile species from the skin surface (cm-2 s-1)
Js_oil_vol(i)=ks_oil_vol(i)*z(i,1); %Flux of volatile species from the sorption layer to the skin oil (cm-2 s-1)
Joil_svol(i)=koil_s_vol(i)*z(i,2); %Flux of volatile species from the skin oil to the sorption layer (cm-2 s-1)
end

for i=[1,17:19,23:26]
k_gas_clothes(i)=1e8;% Transport from the clothing gas phase to the clothing condensed phase (cm s-1) %Set to be high for instantaneous partitioning
k_clothes_gas(i)=k_gas_clothes(i)./K_clothing(i);%Transport from the clothing condensed phase to the clothing gas phase (cm s-1)
end

for i=[1,17:19,23:26]
for j=1:clothesL
J_gas_clothes(i,j)=k_gas_clothes(i)*z(i,oilL+scL1+veL+1+j); %Flux from the clothing gas phase to the clothing condensed phase (cm-2 s-1)
J_clothes_gas(i,j)=k_clothes_gas(i)*z(i,oilL+scL1+veL+clothesL+1+j); %Flux from the clothing condensed phase to the clothing gas phase (cm-2 s-1)
end
end

%%%%%%%-------Transport fluxes for all species-----%%%%%%

k_oil_clothes=2.8e-10;%Contact transfer coefficient from the skin oil to the clothing (cm s-1)
k_clothes_oil=k_oil_clothes;%Contact transfer coefficient from the clothing to the skin oil (cm s-1)

Joil_clothes_total=zeros(30,1);
Jclothes_oil=zeros(30,clothesL);
Jclothes_oil_total=zeros(30,1);

for i=[4,5,17:19,23:26]
    Joil_clothes_total(i)=k_oil_clothes.*z(i,2); % Contact transfer flux from the skin oil to the clothing (cm-2 s-1)
end

for i=[4,5,17:19,23:26]
    for j=oilL+scL1+veL+clothesL+1:oilL+scL1+veL+clothesL+clothesL
        Jclothes_oil(i,j-oilL-scL1-veL-clothesL)=k_clothes_oil.*z(i,j+1); % Contact transfer flux from the clothing to the skin oil (cm-2 s-1)
    end
end

for i=[4,5,17:19,23:26]
   Jclothes_oil_total(i)=sum(Jclothes_oil(i,1:clothesL)); % Sum of the contact transfers for all clothing layers (cm-2 s-1)
end
%Fluxes between different types of layers
Jsc2_ve=zeros(NCom,1);
Jve_sc2=zeros(NCom,1);
Joil_sc1=zeros(NCom,1);
Jsc1_oil=zeros(NCom,1);
Jclothes_bl=zeros(NCom,1);
Jbl_clothes=zeros(NCom,1);
Jclothes_gap=zeros(NCom,1);
Jgap_clothes=zeros(NCom,1);
Jsc1_sc2=zeros(NCom,1);
Jsc2_sc1=zeros(NCom,1);

for i=1:NCom
Jsc2_ve(i)= scvekbb(i).*z(i,oilL+scL1+veL+(2*clothesL)+2+scL2+2); %from the stratum corneum to the viable epidermis (cm-2 s-1)
Jve_sc2(i)= scvekbb(i).*z(i,oilL+scL1+2);%from the viable epidermis to the stratum corneum (cm-2 s-1)
Joil_sc1(i)= oil_sc_kbb(i)*z(i,oilL+1); %from the skin oil to the stratum corneum (cm-2 s-1)
Jsc1_oil(i)= oil_sc_kbb(i)*z(i,oilL+2); %from the stratum corneum to the skin oil (cm-2 s-1)
Jclothes_bl(i)=kclothes_bl_clothes(i)*z(i,oilL+scL1+veL+2); % from the top of the clothing to the gas phase next to the clothing (cm-2 s-1)
Jbl_clothes(i)=kclothes_bl_clothes(i)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(i-1)+2)); %from the gas phase next to the clothing to the top of the clothing (cm-2 s-1)
Jclothes_gap(i)=kclothes_gap(i)*z(i,oilL+scL1+veL+clothesL+1); %from the bottom of the clothing to the gap between the clothing and skin (cm-2 s-1)
Jgap_clothes(i)=kclothes_gap(i)*z(i,oilL+scL1+veL+(2*clothesL)+3); %from the gap between the clothing and skin to the bottom of the clothing (cm-2 s-1)
Jsc1_sc2(i)= ksc1_sc2(i)*z(i,oilL+scL1+1); %from the bottom of the higher stratum corneum layers to the top of the lower stratum corneum layers (cm-2 s-1)
Jsc2_sc1(i)= ksc1_sc2(i)*z(i,oilL+scL1+veL+(2*clothesL)+2+3); %from the top of the lower stratum corneum layers to the bottom of the higher stratum corneum layers (cm-2 s-1)
Jgap_mfp(i)= kclothes_gap_mfp(i)*z(i,oilL+scL1+veL+(2*clothesL)+3); % from the gap to the mfp above the skin (cm-2 s-1)
Jmfp_gap(i)= kclothes_gap_mfp(i)*z(i,oilL+scL1+veL+(2*clothesL)+2+2); % from the mfp above the skin to the gap (cm-2 s-1)
end
for i=[4,20:22,27:30]
Joil_sc1(i)= oil_sc_kbb(i)*z(i,oilL+1)./20; %from the oil to the stratum corneum maintaining a concentration 20 times lower in the stratum corneum (cm-2 s-1)
end

% Fluxes between the same types of layers
Jsc1_sc1=zeros(NCom,scL1,scL1);
Jsc2_sc2=zeros(NCom,scL2,scL2);
Jve_ve=zeros(NCom,veL,veL);
Joil_oil=zeros(NCom,oilL,oilL);
Jclothes_clothes=zeros(NCom,clothesL,clothesL);
Jve_blood=zeros(NCom,1);

%Fluxes between the higher layers of the stratum corneum (cm-2 s-1)
for i=1:NCom
    for m=1:scL1-1
        Jsc1_sc1(i,m,m+1)= sckbb1(i).*z(i,oilL+1+m);
        Jsc1_sc1(i,m+1,m)= sckbb1(i).*z(i,oilL+2+m);
    end
end

%Fluxes between the lower layers of the stratum corneum (cm-2 s-1)
for i=1:NCom
    for m=1:scL2-1
        Jsc2_sc2(i,m,m+1)= sckbb2(i).*z(i,oilL+scL1+veL+(2*clothesL)+2+2+m);%stratum corneum bulk
        Jsc2_sc2(i,m+1,m)= sckbb2(i).*z(i,oilL+scL1+veL+(2*clothesL)+2+3+m);%stratum corneum bulk
    end
end

%Fluxes between the skin oil layers (cm-2 s-1)
for i=1:NCom
    for m=1:oilL-1
        Joil_oil(i,m,m+1)=oil_kbb(i).*z(i,1+m);%oil bulk
        Joil_oil(i,m+1,m)=oil_kbb(i).*z(i,2+m);%oil bulk
    end
end

%Fluxes between gas phase layers in the clothing (cm-2 s-1)
for i=1:NCom
    for m=1:clothesL-1
        Jclothes_clothes(i,m,m+1)=kclothes_bb(i).*z(i,oilL+scL1+veL+1+m);
        Jclothes_clothes(i,m+1,m)=kclothes_bb(i).*z(i,oilL+scL1+veL+2+m);
    end
end

%Fluxes between the viable epidermis layers (cm-2 s-1)
for i=1:NCom
    for m=1:veL-1
        Jve_ve(i,m,m+1)= vekbb(i).*z(i,oilL+scL1+m+1); %viable epidermis bulk
        Jve_ve(i,m+1,m)= vekbb(i).*z(i,oilL+scL1+m+2); %viable epidermis bulk
    end
end

k_ve_blood=99999; %Transport into the blood (cm s-1) set to be high to maintain rapid transport into the blood
%Fluxes into the bloodstream
for i=1:30
    Jve_blood(i)=k_ve_blood.*z(i,oilL+scL1+veL+1);
end

%-------Net flux between the gas-phase and gas phase near the clothing (cm-2 s-1)----------
%O3
F_net_O3_1=(hm(1)*2*(y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)-y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+2)));
%Volatile species
for i=[17:19,23:26]
    F_net_1(i)=(hm(i)*2*(y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(i-1)*2+1)-y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(i-1)*2+2)));
end 

%%%%%%%%---Gas phase reaction rate coefficients, O3 production and air exchange--------%%%%%%

kgr(2)=43e-17; %cm3s-1 Reaction R2
kgr(3)=86e-17; %cm3s-1 Reaction R3
kgr(7)=43e-17; %cm3s-1 Reaction R7
kgr(8)=43e-17; %cm3s-1 Reaction R8
kgr(15)=2.2572e8;%cm-3 s-1 O3 production (maintains an O3 concentration of 33 ppb in the absence of people)
kgr(16)=(1/3600)*Airexchangerate; %s-1 Air exchange rate

%%%%%%----Bulk reaction rate constants--------%%%%%
kbr(1)= 1.25e-16*1;% cm3s-1 %Reaction R1
kbr(2)= 1.25e-16*(1/6)*1;% cm3s-1 %Reaction R2
kbr(3)= 1.25e-16*(2/6)*1;% cm3s-1 %Reaction R3
kbr(4)= 1.25e-16*(4/6)*1;% cm3s-1 %Reaction R4
kbr(5)= 1.25e-16*(5/6)*1;% cm3s-1 %Reaction R5
kbr(6)= 1.25e-16*(3/6)*1;% cm3s-1 %Reaction R6
kbr(7)= 1.25e-16*(1/6)*1;% cm3s-1 %Reaction R7
kbr(8)= 1.25e-16*(1/6)*1;% cm3s-1 %Reaction R8
kbr(9)= 1.25e-16*(2/6)*1;% cm3s-1 %Reaction R9
kbr(10)= 1.25e-16*(2/6)*1;% cm3s-1 %Reaction R10
kbr(11)= 1.25e-16*(3/6)*1;% cm3s-1 %Reaction R11
kbr(12)= 1.25e-16*(4/6)*1;% cm3s-1 %Reaction R12
kbr(13)=1.25e-16/2;% cm3s-1 %Reaction R13
kbr(14)=1.25e-16/3;% cm3s-1 %Reaction R14
kbr(15)=1.25e-16/10;% cm3s-1 %Reaction R15
   

%%%%%%%--------------Production and loss rates (cm-3 s-1)-----------------%%%%%%%

%%%%%%%------------In the gas phase (main room, includes air-exchange)------------%%%%%%%
Pg=zeros(NCom,2);

%O3
Pg(1,1)=-kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+1))...
    -kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))...
    -kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+1))...
    -kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+1))...
    +kgr(15)-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1); 
%Acetone
Pg(17,1)=kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+1))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))...
        -kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(17-1)+1)); 
%6-MHO
Pg(18,1)=-kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+1))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))...
    -kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+1)); 
%Geranyl acetone
Pg(19,1)=-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))-kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1));
%4-OPA
Pg(23,1)=kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+1))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))...
    +2*kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+1))...
    +kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+1))-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(23-1)+1));
%4-MON
Pg(24,1)=(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+1))...
    -kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+1))-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+1));
%4-MOD
Pg(25,1)=-kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+1))-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+1));
%1,4 butanedial
Pg(26,1)=kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+1))-kgr(16)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(26-1)+1));

%%%%%%%------------In the near surface gas phase ------------%%%%%%%
for m=2
%O3    
Pg(1,m)=-kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+m))...
    -kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m))...
    -kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+m))...
    -kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+m)); 
%Acetone
Pg(17,m)=kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+m))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m)); 
%6-MHO
Pg(18,m)=-kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+m))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m)); 
%Geranyl acetone
Pg(19,m)=-kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m));
%4-OPA
Pg(23,m)=kgr(2)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(18-1)+m))...
    +(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m))...
    +2*kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+m))...
    +kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+m));
%4-MON
Pg(24,m)=(1/2)*kgr(3)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(19-1)+m))...
    -kgr(7)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(24-1)+m));
%4-MOD
Pg(25,m)=-kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+m));
%1,4 butanedial
Pg(26,m)=kgr(8)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+m)*y((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(25-1)+m));

end
%%%%%%%------------In the clothing gas phase ------------%%%%%%%
Pg_clothes=zeros(NCom,oilL+scL1+veL+(2*clothesL)+2+2);
for m=oilL+scL1+veL+2:oilL+scL1+veL+clothesL+1
%O3    
Pg_clothes(1,m)=-kgr(2)*z(1,m)*z(18,m)...
    -kgr(3)*z(1,m)*z(19,m)...
    -kgr(7)*z(1,m)*z(24,m)...
    -kgr(8)*z(1,m)*z(25,m)-k_gas_clothes(1)*z(1,m)+k_clothes_gas(1)*z(1,m+clothesL); 
%Acetone
Pg_clothes(17,m)=kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m)-k_gas_clothes(17)*z(17,m)+k_clothes_gas(17)*z(17,m+clothesL); 
%6-MHO
Pg_clothes(18,m)=-kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m)-k_gas_clothes(18)*z(18,m)+k_clothes_gas(18)*z(18,m+clothesL); 
%Geranyl acetone
Pg_clothes(19,m)=-kgr(3)*z(1,m)*z(19,m)...
    -k_gas_clothes(19)*z(19,m)+k_clothes_gas(19)*z(19,m+clothesL);
%4-OPA
Pg_clothes(23,m)=kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m)...
    +2*kgr(7)*z(1,m)*z(24,m)...
    +kgr(8)*z(1,m)*z(25,m)...
    -k_gas_clothes(23)*z(23,m)+k_clothes_gas(23)*z(23,m+clothesL);
%4-MON
Pg_clothes(24,m)=(1/2)*kgr(3)*z(1,m)*z(19,m)...
    -kgr(7)*z(1,m)*z(24,m)-k_gas_clothes(24)*z(24,m)+k_clothes_gas(24)*z(24,m+clothesL);
%4-MOD
Pg_clothes(25,m)=-kgr(8)*z(1,m)*z(25,m)-k_gas_clothes(25)*z(25,m)+k_clothes_gas(25)*z(25,m+clothesL);
%1,4 butanedial
Pg_clothes(26,m)=kgr(8)*z(1,m)*z(25,m)-k_gas_clothes(26)*z(26,m)+k_clothes_gas(26)*z(26,m+clothesL);
end

%%%%%%%------------In the gas phase gap ------------%%%%%%%
for m=oilL+scL1+veL+(2*clothesL)+3:oilL+scL1+veL+(2*clothesL)+2+2
%O3    
Pg_clothes(1,m)=-kgr(2)*z(1,m)*z(18,m)...
    -kgr(3)*z(1,m)*z(19,m)...
    -kgr(7)*z(1,m)*z(24,m)...
    -kgr(8)*z(1,m)*z(25,m); 
%Acetone
Pg_clothes(17,m)=kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m); 
%6-MHO
Pg_clothes(18,m)=-kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m); 
%Geranyl acetone
Pg_clothes(19,m)=-kgr(3)*z(1,m)*z(19,m);
%4-OPA
Pg_clothes(23,m)=kgr(2)*z(1,m)*z(18,m)...
    +(1/2)*kgr(3)*z(1,m)*z(19,m)...
    +2*kgr(7)*z(1,m)*z(24,m)...
    +kgr(8)*z(1,m)*z(25,m);
%4-MON
Pg_clothes(24,m)=(1/2)*kgr(3)*z(1,m)*z(19,m)...
    -kgr(7)*z(1,m)*z(24,m);
%4-MOD
Pg_clothes(25,m)=-kgr(8)*z(1,m)*z(25,m);
%1,4 butanedial
Pg_clothes(26,m)=kgr(8)*z(1,m)*z(25,m);
end

%%%%%%%------------In the skin oil ------------%%%%%%%
Pb=zeros(NCom,oilL+scL1+veL+(2*clothesL)+2+scL2+1);
for j=1:oilL  
   %O3
    Pb(1,j)=-kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)...
    -kbr(4)*z(1,j+1)*z(21,j+1)-kbr(5)*z(1,j+1)*z(20,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    -kbr(10)*z(1,j+1)*z(28,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)-kbr(12)*z(1,j+1)*z(30,j+1)...
    -kbr(13)*z(1,j+1)*z(5,j+1);
%Acetone
Pb(17,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)+kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%6-MHO
Pb(18,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%Geranyl acetone
Pb(19,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%TOT
Pb(20,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(5)*z(1,j+1)*z(20,j+1);
%TOP
Pb(21,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1);
%TTT
Pb(22,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1);
%4-OPA
Pb(23,j)=kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+2*kbr(7)*z(1,j+1)*z(24,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(2/3)*kbr(11)*z(1,j+1)*z(29,j+1)...
   +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%4-MON
Pb(24,j)=(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%4-MOD
Pb(25,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1);
%1,4 butanedial
Pb(26,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1);
%Product A
Pb(27,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%Product B
Pb(28,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)-kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1);
%Product C
Pb(29,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)...
    +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%Product D
Pb(30,j)=(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(12)*z(1,j+1)*z(30,j+1);    
end

%%%%%%%------------In the absorbed phase layers in the clothing ------------%%%%%%%
for j=oilL+scL1+veL+clothesL+1:oilL+scL1+veL+clothesL+clothesL 
  %O3
Pb(1,j)=-kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)...
    -kbr(4)*z(1,j+1)*z(21,j+1)-kbr(5)*z(1,j+1)*z(20,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    -kbr(10)*z(1,j+1)*z(28,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)-kbr(12)*z(1,j+1)*z(30,j+1)...
    -kbr(13)*z(1,j+1)*z(5,j+1)-kbr(14)*z(1,j+1)*z(10,j+1)-kbr(15)*z(1,j+1)*z(11,j+1);
%Squalene
Pb(4,j)=-kbr(1)*z(1,j+1)*z(4,j+1);
%Other reactive species
Pb(5,j)=-kbr(13)*z(1,j+1)*z(5,j+1);
%Laundered species 1
Pb(10,j)=-kbr(14)*z(1,j+1)*z(10,j+1);
%Laundered species 2
Pb(11,j)=-kbr(15)*z(1,j+1)*z(11,j+1);
%Acetone
Pb(17,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)+kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%6-MHO
Pb(18,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%Geranyl acetone
Pb(19,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1);
%TOT
Pb(20,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(5)*z(1,j+1)*z(20,j+1);
%TOP
Pb(21,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1);
%TTT
Pb(22,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1);
%4-OPA
Pb(23,j)=kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+2*kbr(7)*z(1,j+1)*z(24,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(2/3)*kbr(11)*z(1,j+1)*z(29,j+1)...
   +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%4-MON
Pb(24,j)=(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%4-MOD
Pb(25,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1);
%1,4 butanedial
Pb(26,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1);
%Product A
Pb(27,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%Product B
Pb(28,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)-kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1);
%Product C
Pb(29,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)...
    +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1);
%Product D
Pb(30,j)=(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(12)*z(1,j+1)*z(30,j+1);
end


%---------------In the stratum corneum and viable epidermis---------------------
Removal1=1e-4; %First order loss rate of 6-MHO in the skin (s-1)
Removal2=1e-4; %First order loss rate of geranyl acetone in the skin (s-1)
Removal3=1e-4; %First order loss rate of 4-OPA in the skin (s-1)
Removal4=1e-4; %First order loss rate of 1,4 butanedial in the skin (s-1)
Removal5=1e-4; %First order loss rate of other carbonyls in the skin (s-1)
for j=[oilL+1:scL1+veL+oilL,oilL+scL1+veL+(2*clothesL)+2+2:oilL+scL1+veL+(2*clothesL)+2+scL2+1] 
   %O3
    Pb(1,j)=-kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)...
    -kbr(4)*z(1,j+1)*z(21,j+1)-kbr(5)*z(1,j+1)*z(20,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    -kbr(10)*z(1,j+1)*z(28,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)-kbr(12)*z(1,j+1)*z(30,j+1)...
    -kbr(13)*z(1,j+1)*z(5,j+1);
%Acetone
    Pb(17,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)+kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-Removal5*z(17,j+1);
%6-MHO
    Pb(18,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)...
    +(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-Removal1*z(18,j+1);
%Geranyl acetone
    Pb(19,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-Removal2*z(19,j+1);
%TOT
    Pb(20,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(5)*z(1,j+1)*z(20,j+1)-Removal5*z(20,j+1);
%TOP
    Pb(21,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-Removal5*z(21,j+1);
%TTT
    Pb(22,j)=(1/3)*kbr(1)*z(1,j+1)*z(4,j+1)-kbr(6)*z(1,j+1)*z(22,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-Removal5*z(22,j+1);
%4-OPA
    Pb(23,j)=kbr(2)*z(1,j+1)*z(18,j+1)+(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)+2*kbr(7)*z(1,j+1)*z(24,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(2/3)*kbr(11)*z(1,j+1)*z(29,j+1)...
   +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1)-Removal3*z(23,j+1);
%4-MON
    Pb(24,j)=(1/2)*kbr(3)*z(1,j+1)*z(19,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)...
    -kbr(7)*z(1,j+1)*z(24,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1)-Removal5*z(24,j+1);
%4-MOD
    Pb(25,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)-kbr(8)*z(1,j+1)*z(25,j+1)+(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)...
    +(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)+kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)-Removal5*z(25,j+1);
%1,4 butanedial
    Pb(26,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+kbr(8)*z(1,j+1)*z(25,j+1)+(1/2)*kbr(9)*z(1,j+1)*z(27,j+1)-Removal4*z(26,j+1);
%Product A
    Pb(27,j)=(1/3)*kbr(6)*z(1,j+1)*z(22,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(9)*z(1,j+1)*z(27,j+1)...
    +(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)+(1/2)*kbr(12)*z(1,j+1)*z(30,j+1)-Removal5*z(27,j+1);
%Product B
    Pb(28,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)-kbr(10)*z(1,j+1)*z(28,j+1)+(1/3)*kbr(11)*z(1,j+1)*z(29,j+1)-Removal5*z(28,j+1);
%Product C
    Pb(29,j)=(1/4)*kbr(4)*z(1,j+1)*z(21,j+1)+(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(11)*z(1,j+1)*z(29,j+1)...
    +(1/2)*kbr(12)*z(1,j+1)*z(30,j+1)-Removal5*z(29,j+1);
%Product D
    Pb(30,j)=(1/5)*kbr(5)*z(1,j+1)*z(20,j+1)-kbr(12)*z(1,j+1)*z(30,j+1)-Removal5*z(30,j+1);

end

%---------------------------------------------------------------------

%%%%%%%%%%--------Differential equations: Change in concentrations over time (cm-3 s-1 unless stated)--------------%%%%%%%%%%
%Ozone gas phase main room
dydt((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+1)= Pg(1,1)-F_net_O3_1*S/Volume_of_room;
%O3 near clothing gas
dydt((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+2)= Pg(1,2)+F_net_O3_1.*hm(1)/Dg(1)...
    -(Jbl_clothes(1)-Jclothes_bl(1)).*hm(1)/Dg(1);

for i=[17:19,23:26]
%Volatile species gas phase main room
dydt((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(i-1))+1)= Pg(i,1)-F_net_1(i)*S/Volume_of_room ;% volatile species gas
%Volatile species near clothing gas
dydt((oilL+scL1+veL+(2*clothesL)+2+2+scL2)*NCom+(2*(i-1))+2)= Pg(i,2)+F_net_1(i).*hm(i)/Dg(i)...
    -(Jbl_clothes(i)-Jclothes_bl(i)).*hm(i)/Dg(i);%volatile species near clothes gas
end

%------------Gas phase species--------------------
%-----------O3---------
%Surface (sorption layer, cm-2 s-1)
dzdt(1,1)=JadsO3_1-JdesO3_1-Js_oil_O3+Joil_sO3;
%First skin oil layer
dzdt(1,2)=(Js_oil_O3-Joil_sO3).*A/V_oil+(Joil_oil(1,2,1)-Joil_oil(1,1,2)).*A/V_oil+Pb(1,1)...
    +(Jclothes_oil_total(1)/clothesL-Joil_clothes_total(1)).*A/V_oil;
%Middle skin oil layers
for m=3:oilL
    dzdt(1,m)=(Joil_oil(1,m-2,m-1)-Joil_oil(1,m-1,m-2)).*A/V_oil+(Joil_oil(1,m,m-1)-Joil_oil(1,m-1,m)).*A/V_oil+Pb(1,m-1);
end
%Final skin oil layer
dzdt(1,oilL+1)=(Joil_oil(1,oilL-1,oilL)-Joil_oil(1,oilL,oilL-1)).*A/V_oil+(Jsc1_oil(1)-Joil_sc1(1)).*A/V_oil+Pb(1,oilL);
%First stratum corneum layer (top)
dzdt(1,oilL+2)=(Joil_sc1(1)-Jsc1_oil(1)).*A/V_sc1 +(Jsc1_sc1(1,2,1)-Jsc1_sc1(1,1,2)).*A/V_sc1 +Pb(1,oilL+1);
%Middle stratum corneum layers (top)
for m=3:scL1
dzdt(1,oilL+m)=(Jsc1_sc1(1,m-2,m-1)-Jsc1_sc1(1,m-1,m-2)).*A/V_sc1...
    +(Jsc1_sc1(1,m,m-1)-Jsc1_sc1(1,m-1,m)).*A/V_sc1+Pb(1,m-1+oilL);
end
%Final stratum corneum layer (top)
dzdt(1,oilL+scL1+1)=(Jsc2_sc1(1)-Jsc1_sc2(1)).*A/V_sc1+Pb(1,scL1+oilL)...
        +(Jsc1_sc1(1,scL1-1,scL1)-Jsc1_sc1(1,scL1,scL1-1))*A/V_sc1;    
%First stratum corneum layer (bottom)    
dzdt(1,oilL+scL1+veL+(2*clothesL)+2+3)=(Jsc1_sc2(1)-Jsc2_sc1(1)).*A/V_sc2 +(Jsc2_sc2(1,2,1)-Jsc2_sc2(1,1,2)).*A/V_sc2...
    +Pb(1,oilL+scL1+veL+(2*clothesL)+2+2);
%Middle stratum corneum layers (bottom)
for m=3:scL2
dzdt(1,oilL+scL1+veL+(2*clothesL)+2+1+m)=(Jsc2_sc2(1,m-2,m-1)-Jsc2_sc2(1,m-1,m-2)).*A/V_sc2...
    +(Jsc2_sc2(1,m,m-1)-Jsc2_sc2(1,m-1,m)).*A/V_sc2+Pb(1,m+oilL+scL1+veL+(2*clothesL)+2);%stratum corneum (bottom)
end
%Final stratum corneum layer (bottom)
dzdt(1,oilL+scL1+veL+(2*clothesL)+2+scL2+2)=(Jve_sc2(1)-Jsc2_ve(1)).*A/V_sc2+Pb(1,oilL+scL1+veL+(2*clothesL)+2+scL2+1)...
        +(Jsc2_sc2(1,scL2-1,scL2)-Jsc2_sc2(1,scL2,scL2-1))*A/V_sc2;    
%First viable epidermis layer
dzdt(1,oilL+scL1+2)=(Jsc2_ve(1)-Jve_sc2(1)).*A/V_ve+Pb(1,1+scL1+oilL)...
        +(Jve_ve(1,2,1)-Jve_ve(1,1,2)).*A/V_ve;    
%Middle viable epidermis layers    
for m=3:veL
    dzdt(1,oilL+scL1+m)=(Jve_ve(1,m-2,m-1)-Jve_ve(1,m-1,m-2)).*A/V_ve...
    +(Jve_ve(1,m,m-1)-Jve_ve(1,m-1,m)).*A/V_ve+Pb(1,oilL+scL1+m-1);  
end
%Final viable epidermis layer
dzdt(1,oilL+scL1+veL+1)=(Jve_ve(1,veL-1,veL)-Jve_ve(1,veL,veL-1)).*A/V_ve+Pb(1,oilL+scL1+veL)...
    -Jve_blood(1).*A/V_ve; 
%First clothing layer (gas)
dzdt(1,oilL+scL1+veL+2)= (Jbl_clothes(1)-Jclothes_bl(1)).*A/(V_clothes*Clothes_fraction_air)...
    +(Jclothes_clothes(1,2,1)-Jclothes_clothes(1,1,2)).*A/(V_clothes*Clothes_fraction_air)+Pg_clothes(1,oilL+scL1+veL+2)...
    +(J_clothes_gas(1,1)-J_gas_clothes(1,1)).*A/(V_clothes*Clothes_fraction_air);
%Middle clothing layers (gas)
for m=3:clothesL
    dzdt(1,oilL+scL1+veL+m)=(Jclothes_clothes(1,m-2,m-1)-Jclothes_clothes(1,m-1,m-2)).*A/(V_clothes*Clothes_fraction_air)...
        +(Jclothes_clothes(1,m,m-1)-Jclothes_clothes(1,m-1,m)).*A/(V_clothes*Clothes_fraction_air)+Pg_clothes(1,oilL+scL1+veL+m)...
        +(J_clothes_gas(1,m-1)-J_gas_clothes(1,m-1)).*A/(V_clothes*Clothes_fraction_air);
end
%Final clothing layer (gas)
    dzdt(1,oilL+scL1+veL+clothesL+1)= (Jclothes_clothes(1,clothesL-1,clothesL)-Jclothes_clothes(1,clothesL,clothesL-1)).*A/(V_clothes*Clothes_fraction_air)...
        +Pg_clothes(1,oilL+scL1+veL+clothesL+1)...
        +(Jgap_clothes(1)-Jclothes_gap(1)).*A/(V_clothes*Clothes_fraction_air)...
        +(J_clothes_gas(1,clothesL)-J_gas_clothes(1,clothesL)).*A/(V_clothes*Clothes_fraction_air);
%Clothing layers (condensed phase)    
    for m=2:clothesL+1
    dzdt(1,oilL+scL1+veL+clothesL+m)=Pb(1,oilL+scL1+veL+clothesL+m-1)...
        -(J_clothes_gas(1,m-1)-J_gas_clothes(1,m-1)).*A/(V_clothes*Clothes_fraction_fibres)...
        +(Joil_clothes_total(1)-Jclothes_oil(1,m-1)).*A/(V_clothes*Clothes_fraction_fibres*clothesL); 
    end
%Into the blood (s-1)
dzdt(1,oilL+scL1+veL+(2*clothesL)+2)=Jve_blood(1).*A; %Accumulated into blood
%Gap between the clothing and the skin
dzdt(1,oilL+scL1+veL+(2*clothesL)+3)=Pg_clothes(1,oilL+scL1+veL+(2*clothesL)+3)...
    -(Jgap_clothes(1)-Jclothes_gap(1)).*A/gapR...
    +(Jmfp_gap(1)-Jgap_mfp(1)).*A/gapR; 
%Mfp next to the surface of the skin
dzdt(1,oilL+scL1+veL+(2*clothesL)+2+2)=Pg_clothes(1,oilL+scL1+veL+(2*clothesL)+2+2)...
    -(Jmfp_gap(1)-Jgap_mfp(1)).*A/mfp_vol(1)...
    -(JadsO3_1-JdesO3_1)./(mfp_vol(1));
 
%-------------Volatile species---------------------

for i=[17:19,23:26]
%Surface (sorption layer, cm-2 s-1)
dzdt(i,1)=Jads_1(i)-Jdes_1(i)-Js_oil_vol(i)+Joil_svol(i);
%First skin oil layer
dzdt(i,2)=(Js_oil_vol(i)-Joil_svol(i)).*A/V_oil+(Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A/V_oil+Pb(i,1)...
    +(Jclothes_oil_total(i)/clothesL-Joil_clothes_total(i)).*A/V_oil; 
%Middle skin oil layers
for m=3:oilL
    dzdt(i,m)=(Joil_oil(i,m-2,m-1)-Joil_oil(i,m-1,m-2)).*A/V_oil+(Joil_oil(i,m,m-1)-Joil_oil(i,m-1,m)).*A/V_oil+Pb(i,m-1); 
end
%Final skin oil layer
dzdt(i,oilL+1)=(Joil_oil(i,oilL-1,oilL)-Joil_oil(i,oilL,oilL-1)).*A/V_oil+(Jsc1_oil(i)-Joil_sc1(i)).*A/V_oil+Pb(i,oilL); 
%First stratum corneum layer (top)
dzdt(i,oilL+2)=(Joil_sc1(i)-Jsc1_oil(i)).*A/V_sc1 +(Jsc1_sc1(i,2,1)-Jsc1_sc1(i,1,2)).*A/V_sc1 +Pb(i,oilL+1);
%Middle stratum corneum layers (top)
for m=3:scL1
dzdt(i,oilL+m)=(Jsc1_sc1(i,m-2,m-1)-Jsc1_sc1(i,m-1,m-2)).*A/V_sc1...
    +(Jsc1_sc1(i,m,m-1)-Jsc1_sc1(i,m-1,m)).*A/V_sc1+Pb(i,m-1+oilL);
end
%Final stratum corneum layer (top)
dzdt(i,oilL+scL1+1)=(Jsc2_sc1(i)-Jsc1_sc2(i)).*A/V_sc1+Pb(i,scL1+oilL)...
        +(Jsc1_sc1(i,scL1-1,scL1)-Jsc1_sc1(i,scL1,scL1-1))*A/V_sc1;    
%First stratum corneum layer (bottom)       
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+3)=(Jsc1_sc2(i)-Jsc2_sc1(i)).*A/V_sc2 +(Jsc2_sc2(i,2,1)-Jsc2_sc2(i,1,2)).*A/V_sc2...
    +Pb(i,oilL+scL1+veL+(2*clothesL)+2+2);
%Middle stratum corneum layers (bottom)   
for m=3:scL2
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+1+m)=(Jsc2_sc2(i,m-2,m-1)-Jsc2_sc2(i,m-1,m-2)).*A/V_sc2...
    +(Jsc2_sc2(i,m,m-1)-Jsc2_sc2(i,m-1,m)).*A/V_sc2+Pb(i,m+oilL+scL1+veL+(2*clothesL)+2);
end
%Final stratum corneum layer (bottom)   
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+scL2+2)=(Jve_sc2(i)-Jsc2_ve(i)).*A/V_sc2+Pb(i,oilL+scL1+veL+(2*clothesL)+2+scL2+1)...
        +(Jsc2_sc2(i,scL2-1,scL2)-Jsc2_sc2(i,scL2,scL2-1))*A/V_sc2;    
%First viable epidermis layer
dzdt(i,oilL+scL1+2)=(Jsc2_ve(i)-Jve_sc2(i)).*A/V_ve+Pb(i,1+scL1+oilL)...
        +(Jve_ve(i,2,1)-Jve_ve(i,1,2)).*A/V_ve;   
%Middle viable epidermis layers    
for m=3:veL
    dzdt(i,oilL+scL1+m)=(Jve_ve(i,m-2,m-1)-Jve_ve(i,m-1,m-2)).*A/V_ve...
    +(Jve_ve(i,m,m-1)-Jve_ve(i,m-1,m)).*A/V_ve+Pb(i,oilL+scL1+m-1);  
end
%Final viable epidermis layer
dzdt(i,oilL+scL1+veL+1)=(Jve_ve(i,veL-1,veL)-Jve_ve(i,veL,veL-1)).*A/V_ve+Pb(i,oilL+scL1+veL)...
    -Jve_blood(i).*A/V_ve; 
%First clothing layer (gas)
dzdt(i,oilL+scL1+veL+2)= (Jbl_clothes(i)-Jclothes_bl(i)).*A/(V_clothes*Clothes_fraction_air)...
    +(Jclothes_clothes(i,2,1)-Jclothes_clothes(i,1,2)).*A/(V_clothes*Clothes_fraction_air)+Pg_clothes(i,oilL+scL1+veL+2)...
    +(J_clothes_gas(i,1)-J_gas_clothes(i,1)).*A/(V_clothes*Clothes_fraction_air);
%Middle clothing layers (gas)
for m=3:clothesL
    dzdt(i,oilL+scL1+veL+m)=(Jclothes_clothes(i,m-2,m-1)-Jclothes_clothes(i,m-1,m-2)).*A/(V_clothes*Clothes_fraction_air)...
        +(Jclothes_clothes(i,m,m-1)-Jclothes_clothes(i,m-1,m)).*A/(V_clothes*Clothes_fraction_air)+Pg_clothes(i,oilL+scL1+veL+m)...
        +(J_clothes_gas(i,m-1)-J_gas_clothes(i,m-1)).*A/(V_clothes*Clothes_fraction_air);
end
%Final clothing layer (gas)
    dzdt(i,oilL+scL1+veL+clothesL+1)= (Jclothes_clothes(i,clothesL-1,clothesL)-Jclothes_clothes(i,clothesL,clothesL-1)).*A/(V_clothes*Clothes_fraction_air)...
        +Pg_clothes(i,oilL+scL1+veL+clothesL+1)...
        +(Jgap_clothes(i)-Jclothes_gap(i)).*A/(V_clothes*Clothes_fraction_air)...
        +(J_clothes_gas(i,clothesL)-J_gas_clothes(i,clothesL)).*A/(V_clothes*Clothes_fraction_air);
%Clothing layers (condensed phase)     
    for m=2:clothesL+1
    dzdt(i,oilL+scL1+veL+clothesL+m)=Pb(i,oilL+scL1+veL+clothesL+m-1)...
        -(J_clothes_gas(i,m-1)-J_gas_clothes(i,m-1)).*A/(V_clothes*Clothes_fraction_fibres)...
    +(Joil_clothes_total(i)-Jclothes_oil(i,m-1)).*A/(V_clothes*Clothes_fraction_fibres*clothesL); 
    end
%Into the blood (s-1)
dzdt(i,oilL+scL1+veL+(2*clothesL)+2)=Jve_blood(i).*A; 
%Gap between the clothing and the skin
dzdt(i,oilL+scL1+veL+(2*clothesL)+3)=Pg_clothes(i,oilL+scL1+veL+(2*clothesL)+3)...
    -(Jgap_clothes(i)-Jclothes_gap(i)).*A/gapR...
    +(Jmfp_gap(i)-Jgap_mfp(i)).*A/gapR; 
%Mfp next to the surface of the skin
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+2)=Pg_clothes(i,oilL+scL1+veL+(2*clothesL)+2+2)...
    -(Jmfp_gap(i)-Jgap_mfp(i)).*A/mfp_vol(i)...
    -(Jads_1(i)-Jdes_1(i))./(mfp_vol(i));
end
%--------------Non volatile species----------------

for i=[4:16,20:22,27:30]
%First skin oil layer
dzdt(i,2)=(Joil_oil(i,2,1)-Joil_oil(i,1,2)).*A/V_oil+Pb(i,1)...
    +(Jclothes_oil_total(i)/clothesL-Joil_clothes_total(i)).*A/V_oil; 
%Middle skin oil layers
for m=3:oilL
    dzdt(i,m)=(Joil_oil(i,m-2,m-1)-Joil_oil(i,m-1,m-2)).*A/V_oil+(Joil_oil(i,m,m-1)-Joil_oil(i,m-1,m)).*A/V_oil+Pb(i,m-1); 
end
%Final skin oil layer
dzdt(i,oilL+1)=(Joil_oil(i,oilL-1,oilL)-Joil_oil(i,oilL,oilL-1)).*A/V_oil+(Jsc1_oil(i)-Joil_sc1(i)).*A/V_oil+Pb(i,oilL); 
%First stratum corneum layer (top)
dzdt(i,oilL+2)=(Joil_sc1(i)-Jsc1_oil(i)).*A/V_sc1 +(Jsc1_sc1(i,2,1)-Jsc1_sc1(i,1,2)).*A/V_sc1 +Pb(i,oilL+1);
%Middle stratum corneum layers (top)
for m=3:scL1
dzdt(i,oilL+m)=(Jsc1_sc1(i,m-2,m-1)-Jsc1_sc1(i,m-1,m-2)).*A/V_sc1...
    +(Jsc1_sc1(i,m,m-1)-Jsc1_sc1(i,m-1,m)).*A/V_sc1+Pb(i,m-1+oilL);
end
%Final stratum corneum layer (top)
dzdt(i,oilL+scL1+1)=(Jsc2_sc1(i)-Jsc1_sc2(i)).*A/V_sc1+Pb(i,scL1+oilL)...
        +(Jsc1_sc1(i,scL1-1,scL1)-Jsc1_sc1(i,scL1,scL1-1))*A/V_sc1;    
%First stratum corneum layer (bottom)    
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+3)=(Jsc1_sc2(i)-Jsc2_sc1(i)).*A/V_sc2 +(Jsc2_sc2(i,2,1)-Jsc2_sc2(i,1,2)).*A/V_sc2...
    +Pb(i,oilL+scL1+veL+(2*clothesL)+2+2);
%Middle stratum corneum layers (bottom)
for m=3:scL2
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+1+m)=(Jsc2_sc2(i,m-2,m-1)-Jsc2_sc2(i,m-1,m-2)).*A/V_sc2...
    +(Jsc2_sc2(i,m,m-1)-Jsc2_sc2(i,m-1,m)).*A/V_sc2+Pb(i,m+oilL+scL1+veL+(2*clothesL)+2);
end
%Final stratum corneum layer (bottom)
dzdt(i,oilL+scL1+veL+(2*clothesL)+2+scL2+2)=(Jve_sc2(i)-Jsc2_ve(i)).*A/V_sc2+Pb(i,oilL+scL1+veL+(2*clothesL)+2+scL2+1)...
        +(Jsc2_sc2(i,scL2-1,scL2)-Jsc2_sc2(i,scL2,scL2-1))*A/V_sc2;    
%First viable epidermis layer
dzdt(i,oilL+scL1+2)=(Jsc2_ve(i)-Jve_sc2(i)).*A/V_ve+Pb(i,1+scL1+oilL)...
        +(Jve_ve(i,2,1)-Jve_ve(i,1,2)).*A/V_ve;    
%Middle viable epidermis layers    
for m=3:veL
    dzdt(i,oilL+scL1+m)=(Jve_ve(i,m-2,m-1)-Jve_ve(i,m-1,m-2)).*A/V_ve...
    +(Jve_ve(i,m,m-1)-Jve_ve(i,m-1,m)).*A/V_ve+Pb(i,oilL+scL1+m-1);  
end
%Final viable epidermis layer
dzdt(i,oilL+scL1+veL+1)=(Jve_ve(i,veL-1,veL)-Jve_ve(i,veL,veL-1)).*A/V_ve+Pb(i,oilL+scL1+veL)...
    -Jve_blood(i).*A/V_ve; 
%Clothing layers (condensed phase)    
    for m=2:clothesL+1
    dzdt(i,oilL+scL1+veL+clothesL+m)=Pb(i,oilL+scL1+veL+clothesL+m-1)...
    +(Joil_clothes_total(i)-Jclothes_oil(i,m-1)).*A/(V_clothes*Clothes_fraction_fibres*clothesL);
    end
%Into the blood (s-1)
dzdt(i,oilL+scL1+veL+(2*clothesL)+2)=Jve_blood(i).*A; 

dzdt(i,oilL+scL1+veL+(2*clothesL)+3)=0; %1st gas phase gap

end
% Concentration of squalene and other reactive species do not change in the skin oil due to replenishment
for i=[4,5]
    dzdt(i,2)=0; % 1st oil
for m=3:oilL
    dzdt(i,m)=0; %bulk oil
end
dzdt(i,oilL+1)=0; %last oil
end
%-----------make 3D dzdt to 1D dydt------------
for i=1:NCom
    for m=1:oilL+scL1+veL+(2*clothesL)+2+2+scL2;
        p=(oilL+scL1+veL+(2*clothesL)+2+2+scL2)*(i-1)+m;
        dydt(p)=dzdt(i,m);
    end
end

%-------------------------------------------------------------------------
%---------------End Differential equations--------------------------------

end
